CREATE TABLE [dbo].[CONFIG_EIS]
(
[ID] [int] NOT NULL IDENTITY(1, 1),
[CONFIG_ID] [int] NOT NULL,
[ENTITY_ID] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ENTITY_NAME] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[ENTITY_TYPE_ID] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[CREATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[CREATED] [datetime] NULL,
[UPDATEDBY] [nvarchar] (50) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[UPDATED] [datetime] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EIS_AfterDelete] 
   ON  [dbo].[CONFIG_EIS] 
   AFTER DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @HISTORY_VALUE NVARCHAR(50)
	
	SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EIS_H]
			   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, 'D', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM deleted;
	 		
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EIS_AfterInsert] 
   ON  [dbo].[CONFIG_EIS] 
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
   
    IF (UPPER(@HISTORY_VALUE) = 'Y')
     	INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EIS_H]
			   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, 'I', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
     
	
END
GO
SET QUOTED_IDENTIFIER OFF
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[utg_Config_EIS_AfterUpdate] 
   ON  [dbo].[CONFIG_EIS] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @HISTORY_VALUE NVARCHAR(50)
    
    SELECT @HISTORY_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'HISTORY';
    
	IF (UPPER(@HISTORY_VALUE) = 'Y')
	 INSERT INTO $(varBMS_HISTORY).[dbo].[Config_EIS_H]
			   (ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, TRANSACTION_TYPE_CODE, DATE, CREATED_BY)
			SELECT ID, CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, 'U', GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_EIS_InsteadOfInsert] 
   ON  [dbo].[CONFIG_EIS]
   INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE PARAMETER = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
     	INSERT INTO [dbo].[Config_EIS]
			   (CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, CREATED, CREATEDBY)
			SELECT CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID, GETUTCDATE(), dbo.ufn_Get_BMS_User_Name()
			  FROM inserted;
	 
	ELSE
		INSERT INTO [dbo].[Config_EIS]
			   (CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID)
			SELECT CONFIG_ID, ENTITY_ID, ENTITY_NAME, ENTITY_TYPE_ID
			  FROM inserted;
	
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[utg_Config_EIS_InsteadOfUpdate] 
   ON  [dbo].[CONFIG_EIS] 
   INSTEAD OF UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	
	DECLARE @AUDIT_VALUE NVARCHAR(50)
    
    SELECT @AUDIT_VALUE=PARAMETER_VALUE
    FROM dbo.Options
    WHERE UPPER(PARAMETER) = 'AUDIT';
    
    IF (UPPER(@AUDIT_VALUE) = 'Y')
	 	UPDATE [dbo].[Config_EIS]
		SET CONFIG_ID = inserted.CONFIG_ID,
			ENTITY_ID = inserted.ENTITY_ID,
			ENTITY_NAME = inserted.ENTITY_NAME,
			ENTITY_TYPE_ID = inserted.ENTITY_TYPE_ID,
			UPDATEDBY = dbo.ufn_Get_BMS_User_Name(),
			UPDATED = GETUTCDATE()
		FROM [dbo].[Config_EIS]
		INNER JOIN inserted ON inserted.id = [dbo].[Config_EIS].id;
	
	 ELSE
	    UPDATE [dbo].[Config_EIS]
		SET CONFIG_ID = inserted.CONFIG_ID,
			ENTITY_ID = inserted.ENTITY_ID,
			ENTITY_NAME = inserted.ENTITY_NAME,
			ENTITY_TYPE_ID = inserted.ENTITY_TYPE_ID
		FROM [dbo].[Config_EIS]
		INNER JOIN inserted ON inserted.id = [dbo].[Config_EIS].id;

END
GO

--Constraints
ALTER TABLE [dbo].[CONFIG_EIS] ADD CONSTRAINT [PK_CONFIG_EIS] PRIMARY KEY CLUSTERED  ([ID]) ON [PRIMARY]
GO
ALTER TABLE [dbo].[CONFIG_EIS] ADD CONSTRAINT [FK_CONFIG_EIS_CONFIG] FOREIGN KEY ([CONFIG_ID]) REFERENCES [dbo].[CONFIG] ([ID])
GO

--Indexes
CREATE NONCLUSTERED INDEX [IDX_CONFIG_ID] ON [dbo].[CONFIG_EIS] 
(
	[CONFIG_ID] ASC
)
INCLUDE ( [ID],
[ENTITY_ID],
[ENTITY_NAME],
[ENTITY_TYPE_ID]) WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
GO

--Extended properties
EXEC sp_addextendedproperty N'MS_Description', N'Entities configuration table.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the configuration.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'CONFIG_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'CREATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was created.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'CREATEDBY'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the entity.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'ENTITY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the entity.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'ENTITY_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Entity''s type id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'ENTITY_TYPE_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Entity configuration''s id.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Datetime when record was changed(updated).', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'UPDATED'
GO
EXEC sp_addextendedproperty N'MS_Description', N'User ID of user when record was updated.', 'SCHEMA', N'dbo', 'TABLE', N'CONFIG_EIS', 'COLUMN', N'UPDATEDBY'
GO
